source("bfgs.R")

ll <- function(x) function(p)
{
	stopifnot(p[2] >= 0)
	-sum(dnorm(x, mean=p[1], sd=p[2], log=T))
}

log.dnorm.expr <- expression(-log (sqrt(2*pi) * sd) - (x - mean)^2/(2*sd^2))

ll.grad <- function(x)
{
      deriv.expr <- deriv(log.dnorm.expr, c("mean", "sd"))
      function(p) -colSums(attr(eval(deriv.expr, list(mean=p[1], sd=p[2])),
                                "gradient"))
}

n <- 500
runs <- 100
estimates <- matrix(nrow=runs, ncol=2)
stderrs <- matrix(nrow=runs, ncol=2)
for (run in 1:runs)
{
	cat(run, "\n")
	x <- rnorm(n, mean=5, sd=10)
	result <- bfgs(x0=c(0, 1), ll(x), ll.grad(x), min.x=c(-Inf, 0))
	estimates[run, ] <- result$par
	stderrs[run, ] <- sqrt(diag(result$inv.hessian))
}

cat("mean estimator performance:\n")
cat("mean = ", mean(estimates[, 1]), "\n")
cat("sd = ", sd(estimates[, 1]), "\n")
cat("mean of sd estimates = ", mean(stderrs[ ,1]), "\n")

cat("sd estimator performance:\n")
cat("mean = ", mean(estimates[, 2]), "\n")
cat("sd = ", sd(estimates[, 2]), "\n")
cat("mean of sd estimates = ", mean(stderrs[ ,2]), "\n")

# Do it with optim.  Note that R's implementation of BFGS doesn't do
# constraints -- you need to use L-BFGS-B.
if (FALSE)
{
	result <- optim(c(0, 1), ll(x), ll.grad(x), method="L-BFGS-B",
			lower=c(-Inf, 0), hessian=TRUE)
	print(result)
}
