name <- "Helical valley function"

xmin <- c(1, 0, 0)
x0 <- c(-1, 0, 0)

theta <- function(x1, x2) 1/(2*pi) * atan(x2 / x1) + (x1 < 0) * 0.5
atan_ <- function(x) 1 / (1 + x^2)
theta_ <- function(x1, x2) 1/(2*pi) * atan_(x2 / x1) * c(-x1^-2, 1/x1)

f1 <- function(x) 10*(x[3] - 10*theta(x[1], x[2]))
f2 <- function(x) 10*(sqrt(x[1]^2 + x[2]^2) - 1)
f3 <- function(x) x[3]
f <- function(x) f1(x)^2 + f2(x)^2 + f3(x)^2

g1 <- function(x) 10*c(-10 * theta_(x[1], x[2]), 1)
g2 <- function(x) c(10*(0.5 / sqrt(x[1]^2 + x[2]^2) * 2*c(x[1], x[2])), 0)
g3 <- function(x) c(0, 0, 1)
g <- function(x) 2*f1(x)*g1(x) + 2*f2(x)*g2(x) + 2*f3(x)*g3(x)

