name <- "Powell badly scaled function"

xmin <- c(1.098e-5, 9.106)
x0 <- c(0, 1)

f1 <- function(x) 10^4 * x[1] * x[2] - 1
f2 <- function(x) exp(-x[1]) + exp(-x[2]) - 1.0001
f <- function(x) f1(x)^2 + f2(x)^2

g1 <- function(x) 10^4 * c(x[2], x[1])
g2 <- function(x) c(-exp(-x[1]), -exp(-x[2]))
g <- function(x) 2*f1(x)*g1(x) + 2*f2(x)*g2(x)

