source("bfgs.R")
source("multimin.R")

sum.squares <- function(x) sum(x^2)

results.bfgs <- list()
results.optim <- list()
results.multimin <- list()
details <- list()

for (file in list.files("tests/functions"))
{
	source(paste("tests/functions/", file, sep=""))
	cat("Testing", name, "--------------------\n")

	details[[file]] <- list(name=name, xmin=xmin)

	result <- bfgs(x0, f, g)
	results.bfgs[[file]] <- list(par=result$par, val=result$val)
	print(result)

	result <- optim(x0, f, g, method="BFGS")
	results.optim[[file]] <- list(par=result$par, val=result$val)
	print(result)

	result <- multimin(x0, f, g, method="bfgs")
	results.multimin[[file]] <- list(par=result$x, val=result$f)
	print(result)
}

cat("Report---------------------------\n")

for (file in names(results.bfgs))
{
	cat("--------------------------\n")
	cat(format(details[[file]]), "\n")
	cat("BFGS:", format(results.bfgs[[file]]), "\n")
	cat("optim:", format(results.optim[[file]]), "\n")
	cat("multimin:", format(results.multimin[[file]]), "\n")
}

